/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.network.toserver;

import de.unhappycodings.quarry.common.blockentity.QuarryBlockEntity;
import de.unhappycodings.quarry.common.network.PacketHandler;
import de.unhappycodings.quarry.common.network.base.IPacket;
import de.unhappycodings.quarry.common.network.toclient.QuarryClientModePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class QuarryModePacket
implements IPacket {
    private final BlockPos pos;
    private final int add;

    public QuarryModePacket(BlockPos pos, int add) {
        this.pos = pos;
        this.add = add;
    }

    public static QuarryModePacket decode(FriendlyByteBuf buffer) {
        return new QuarryModePacket(buffer.m_130135_(), buffer.readInt());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        BlockEntity machine = player.m_20193_().m_7702_(this.pos);
        if (!(machine instanceof QuarryBlockEntity)) {
            return;
        }
        QuarryBlockEntity blockEntity = (QuarryBlockEntity)machine;
        if (this.add != -1) {
            int newMode = blockEntity.getMode() + this.add;
            if (this.add == 10) {
                newMode = blockEntity.getMode() - 1;
                if (newMode < 0) {
                    newMode = 4;
                }
                blockEntity.setMode(newMode);
                PacketHandler.sendToClient(new QuarryClientModePacket(machine.m_58899_(), newMode), player);
                return;
            }
            if (newMode >= 0 && newMode <= 4) {
                blockEntity.setMode(newMode);
                PacketHandler.sendToClient(new QuarryClientModePacket(machine.m_58899_(), newMode), player);
            } else {
                blockEntity.setMode(0);
                PacketHandler.sendToClient(new QuarryClientModePacket(machine.m_58899_(), 0), player);
            }
        } else {
            PacketHandler.sendToClient(new QuarryClientModePacket(machine.m_58899_(), blockEntity.getMode()), player);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.add);
    }
}

